<?php
	include('../../conf.php');
	// GRAFICO VENTAS MES / DIA
	$anno_in 		= '2019';
	$anno_actual 	= date('Y');
	$mes 			= date('m');
?>


<div class="row">
	<div id="container" style="min-width: 310px; height: 400px; margin: 0 auto"></div>
</div>

<script type="text/javascript">
	$(document).ready(function(){
		Highcharts.chart('container', {
		    chart: {
		        type: 'column'
		    },
		    title: {
		        text: 'Cantidad retiro en tienda mes <?= NombreMes($mes); ?>'
		    },
		    subtitle: {
		        text: ''
		    },
		    xAxis: {
		        categories: [
		        	<?php for($d = 1; $d <= cantDias($mes); $d++){
		        		if(strlen($d) > 2) $dia = "0".$d;
			        	else $dia = $d;
		        		echo $dia.",";
		        	} ?>
		        ],
		        crosshair: true
		    },
		    yAxis: {
		        min: 0,
		        title: {
		            text: 'Rainfall (mm)'
		        }
		    },
		    tooltip: {
		        headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
		        pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
		            '<td style="padding:0"><b>${point.y}</b></td></tr>',
		        footerFormat: '</table>',
		        shared: true,
		        useHTML: true
		    },
		    plotOptions: {
		        column: {
		            pointPadding: 0.2,
		            borderWidth: 0
		        }
		    },
		    series: [
		    	<?php for($anno_in; $anno_in <= $anno_actual; $anno_in++){ ?>
			    {
			        name: '<?= NombreMes($mes)." ".$anno_in; ?>',
			        data: [
			        	<?php for($d = 1; $d <= cantDias($mes); $d++){

			        		if(strlen($d) > 2) $dia = "0".$d;
			        		else $dia = $d;

			        		$fecha_in = $anno_in."-".$mes."-".$dia;
			        		$row = consulta_bd("COUNT(despacho)","pedidos","estado_id = 2 AND fecha = '$fecha_in' AND retiro_en_tienda = 1","");
			        		
			        		if($row[0][0]){
			        			echo $row[0][0].",";
			        		}else{
			        			echo "0,";
			        		}

			        	} ?>
			        ]
			    },
				<?php } ?>
		    ]
		});
	});
</script>


<?php
	function cantDias($mes){
		switch ($mes) {
			case '01':
				$dias = '31';
				break;
			case '02':
				$dias = '28';
				break;
			case '03':
				$dias = '31';
				break;
			case '04':
				$dias = '30';
				break;
			case '05':
				$dias = '31';
				break;
			case '06':
				$dias = '30';
				break;
			case '07':
				$dias = '31';
				break;
			case '08':
				$dias = '31';
				break;
			case '09':
				$dias = '30';
				break;
			case '10':
				$dias = '31';
				break;
			case '11':
				$dias = '30';
				break;
			case '12':
				$dias = '31';
				break;
		}
		return $dias;
	}

	function NombreMes($mes){
		switch ($mes) {
			case '01':
				$name = 'Enero';
				break;
			case '02':
				$name = 'Febrero';
				break;
			case '03':
				$name = 'Marzo';
				break;
			case '04':
				$name = 'Abril';
				break;
			case '05':
				$name = 'Mayo';
				break;
			case '06':
				$name = 'Junio';
				break;
			case '07':
				$name = 'Julio';
				break;
			case '08':
				$name = 'Agosto';
				break;
			case '09':
				$name = 'Septiembre';
				break;
			case '10':
				$name = 'Octubre';
				break;
			case '11':
				$name = 'Noviembre';
				break;
			case '12':
				$name = 'Diciembre';
				break;
		}
		return $name;
	}
?>