<?php
	include('../../conf.php');
	// GRAFICO PRODUCTOS VENDIDOS
	$anno_in 		= '2019';
	$anno_actual 	= date('Y');
	
	$producto_mas_vendido = consulta_bd("pd.nombre, SUM(pp.cantidad) as cant","pedidos p, productos_pedidos pp, productos_detalles pd","p.id = pp.pedido_id AND p.estado_id = 2 AND pp.productos_detalle_id = pd.id GROUP BY pp.productos_detalle_id","cant DESC LIMIT 10");

?>


<div class="row">
	<div id="container" style="min-width: 310px; height: 400px; margin: 0 auto"></div>
</div>


<script type="text/javascript">
	$(document).ready(function(){
		Highcharts.chart('container', {
		    chart: {
		        type: 'line'
		    },
		    title: {
		        text: 'Ranking de productos más vendidos'
		    },
		    subtitle: {
		        text: ''
		    },
		    xAxis: {
		        categories: [
		        	<?php foreach($producto_mas_vendido as $pmv){ ?>
		        		'<?= $pmv[0]; ?>', 
		        	<?php } ?>
		        ]
		    },
		    yAxis: {
		        title: {
		            text: 'Cantidad'
		        }
		    },
		    plotOptions: {
		        line: {
		            dataLabels: {
		                enabled: true
		            },
		            enableMouseTracking: false
		        }
		    },
		    series: [
			    {
			        name: '',
			        data: [
			        	<?php foreach($producto_mas_vendido as $pmv){ ?>
			        		<?= $pmv[1]; ?>, 
			        	<?php } ?>
			        ]
			    }
		    ]
		});
	});
</script>