<?php
	include('../../conf.php');
	// GRAFICO TODOS LOS PEDIDOS MENSUALES * AÑO
	$anno_in 		= '2019';
	$anno_actual 	= date('Y');
	//$total_ventas_anno = consulta_bd("SUM(total)","pedidos","estado_id = 2 AND fecha >= '$anno_in' AND fecha <= '$anno_out'","");
?>


<div class="row">
	<div id="container" style="min-width: 310px; height: 400px; margin: 0 auto"></div>
</div>

<script type="text/javascript">
	$(document).ready(function(){
		Highcharts.chart('container', {
		    chart: {
		        type: 'column'
		    },
		    title: {
		        text: 'Total despachos año '
		    },
		    subtitle: {
		        text: ''
		    },
		    xAxis: {
		        categories: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
		        crosshair: true
		    },
		    yAxis: {
		        min: 0,
		        title: {
		            text: 'Rainfall (mm)'
		        }
		    },
		    tooltip: {
		        headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
		        pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
		            '<td style="padding:0"><b>${point.y}</b></td></tr>',
		        footerFormat: '</table>',
		        shared: true,
		        useHTML: true
		    },
		    plotOptions: {
		        column: {
		            pointPadding: 0.2,
		            borderWidth: 0
		        }
		    },
		    series: [
		    	<?php for($anno_in; $anno_in <= $anno_actual; $anno_in++){ ?>
			    {
			        name: <?= $anno_in; ?>,
			        data: [
			        	<?php for($m = 1; $m <= 12; $m++){

			        		if(strlen($m) > 2) $mes = "0".$m;
			        		else $mes = $m;

			        		$fecha_in = $anno_in."-".$mes."-01";
			        		$fecha_out = $anno_in."-".$mes."-31";
			        		$row = consulta_bd("SUM(despacho)","pedidos","estado_id = 2 AND fecha >= '$fecha_in' AND fecha <= '$fecha_out'","");
			        		
			        		if($row[0][0]){
			        			echo $row[0][0].",";
			        		}else{
			        			echo "0,";
			        		}

			        	} ?>
			        ]
			    },
				<?php } ?>
		    ]
		});
	});
</script>