<?php
	include('../../conf.php');
	// GRAFICO CANTIDAD DE PRODUCTOS VENDIDOS MES X AÑO
	$anno_in 		= '2019';
	$anno_actual 	= date('Y');
	$total_productos_vendidos = consulta_bd("SUM(cantidad)","pedidos p, productos_pedidos pp","p.id = pp.pedido_id AND p.estado_id = 2","");
?>


<div class="row">
	<div id="container" style="min-width: 310px; height: 400px; margin: 0 auto"></div>
</div>


<script type="text/javascript">
	$(document).ready(function(){
		Highcharts.chart('container', {
		    chart: {
		        type: 'line'
		    },
		    title: {
		        text: 'Total productos vendidos'
		    },
		    subtitle: {
		        text: ''
		    },
		    xAxis: {
		        categories: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic']
		    },
		    yAxis: {
		        title: {
		            text: 'Cantidad'
		        }
		    },
		    plotOptions: {
		        line: {
		            dataLabels: {
		                enabled: true
		            },
		            enableMouseTracking: false
		        }
		    },
		    series: [

		    <?php for($anno_in; $anno_in <= $anno_actual; $anno_in++){ ?>
		    {
		        name: <?= $anno_in; ?>,
		        data: [
		        	<?php for($m = 1; $m <= 12; $m++){

		        		if(strlen($m) > 2) $mes = "0".$m;
		        		else $mes = $m;

		        		$fecha_in = $anno_in."-".$mes."-01";
		        		$fecha_out = $anno_in."-".$mes."-31";
		        		$row = consulta_bd("SUM(pp.cantidad)","pedidos p, productos_pedidos pp","p.id = pp.pedido_id AND p.estado_id = 2 AND p.fecha >= '$fecha_in' AND p.fecha <= '$fecha_out'","");
		        		$cant = ($row[0][0]) ? $row[0][0] : 0;
		        		echo $cant.",";

		        	} ?>
		        ]
		    },
			<?php } ?>

		    ]
		});
	});
</script>