$(window).scroll(function() {
  
  // selectors
  var $window = $(window),
      $body = $('body'),
      $panel = $('.panel');
  
  // Change 33% earlier than scroll position so colour is there when you arrive.
  var scroll = $window.scrollTop() + ($window.height() / 3);
 
  $panel.each(function () {
    var $this = $(this);
    
    // if position is within range of this panel.
    // So position of (position of top of div <= scroll position) && (position of bottom of div > scroll position).
    // Remember we set the scroll to 33% earlier in scroll var.
    if ($this.position().top <= scroll && $this.position().top + $this.height() > scroll) {
          
      // Remove all classes on body with color-
      $body.removeClass(function (index, css) {
        return (css.match (/(^|\s)color-\S+/g) || []).join(' ');
      });
       
      // Add class of currently active div
      $body.addClass('color-' + $(this).data('color'));
    }
  });    
  
}).scroll();

$(document).ready(function(){
    $('#loader').append('<div></div>');


    $("a").on('click', function(event){

        var distance_top = 0;

        if(!/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
            distance_top = 0;
        }

        if(this.hash !== ""){
            event.preventDefault();
            var hash    = this.hash;
            var top     = $(hash).offset().top - distance_top;
            $('html, body').animate({
                scrollTop: top
            }, 800, function(){
                //window.location.hash = hash;
            });
        }

    });
    
    $('#formContacto').on('submit', function(e){
        e.preventDefault();
        var form        = document.forms['formContacto'];

        var nombre     = $('#nombre').val(); //*
        var email      = $('#email').val(); //*
        var telefono   = $('#telefono').val(); //*


        if(nombre == ''){ swal("",'Ingrese su nombre y apellido',"warning"); form.nombre.focus(); return false; }
        if(email == ''){ swal("",'Ingrese un email',"warning"); form.email.focus(); return false; }
        if(!validarEmail(email)){ swal("",'El email ingresado no es válido',"warning"); form.email.focus(); return false; }

        if(telefono == ''){ swal("",'Ingrese su teléfono',"warning"); form.nombre.focus(); return false; }

        $('.btn-enviar').empty();
        $('.btn-enviar').text("Enviando...");

        $.ajax({
            type    : 'POST',
            url     : 'include/mail.php',
            data    : {nombre:nombre, email:email, telefono:telefono},
            cache   : false,
            success : function(rsp){

                console.log(rsp);

                swal("","Gracias por contactarnos, nos comunicaremos a la brevedad.","success");
                $('#nombre').val("");
                $('#email').val("");
                $('#telefono').val("");

                $('.btn-enviar').empty();
                $('.btn-enviar').text("Enviar");

            }
        });
    });

    $('.btn-menu').on('click', function(){
        if ($(this).find('.x').hasClass('clicked')){
            $('.x').removeClass('clicked');
            $('body').removeClass('menu');
            $('nav').removeClass('open');

        }else{
            $('.x').addClass('clicked');
            $('body').addClass('menu');
            $('nav').addClass('open');
            
        }
    });
    
    $('nav a').on('click', function(){
        $('.x').removeClass('clicked');
        $('body').removeClass('menu');
        $('nav').removeClass('open');
    });

    if(!/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
        $('.servicios .line .serv').hover( function(){
            $('.servicios .black').addClass('visible');
        }, function(){
            $('.servicios .black').removeClass('visible');
        });
    }
});

var wow = new WOW({
    boxClass:     'wow',      // animated element css class (default is wow)
    animateClass: 'animated', // animation css class (default is animated)
    offset:       0,          // distance to the element when triggering the animation (default is 0)
    mobile:       true,       // trigger animations on mobile devices (default is true)
    live:         true,       // act on asynchronously loaded content (default is true)
    callback:     function(box) {
    // the callback is fired every time an animation is started
    // the argument that is passed in is the DOM node being animated
    },
    scrollContainer: null,    // optional scroll container selector, otherwise use window,
    resetAnimation: true,     // reset animation on end (default is true)
});
wow.init();

function validarEmail(valor) {
	var patron=/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,4})+$/;
 	if (valor.search(patron) == 0){
  		return true;
  } else {
   		return false;
  }
}

function valideKey(evt){
    var code = (evt.which) ? evt.which : evt.keyCode;
    if(code==8) {
        return true;
    }else if(code>=48 && code<=57 || code == 9) {
        return true;
    }else{
        return false;
    }
}   
function loading(){
   if($('#loader').is(':visible')) $('#loader').fadeOut('fast');
   else $('#loader').fadeIn('fast');
}